<?php
session_start(); 

$dbFile = 'codigos.db';

try {
    $pdo = new PDO("sqlite:$dbFile");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $pdo->exec("CREATE TABLE IF NOT EXISTS codigos (
                    id INTEGER PRIMARY KEY AUTOINCREMENT,
                    codigo TEXT NOT NULL,
                    username TEXT NOT NULL,
                    password TEXT NOT NULL
                )");
} catch (PDOException $e) {
    die("Error al conectar a la base de datos: " . $e->getMessage());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $codigo = $_POST['codigo'] ?? '';
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if ($codigo && $username && $password) {
        $stmt = $pdo->prepare("INSERT INTO codigos (codigo, username, password) VALUES (?, ?, ?)");
        $stmt->execute([$codigo, $username, $password]);

        $_SESSION['message'] = "✅ Código agregado con éxito!";
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    } else {
        $_SESSION['message'] = "⚠️ Por favor, completa todos los campos.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Agregar Código</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
      body {
          margin: 0;
          font-family: 'Segoe UI', sans-serif;
          background: #0d0d0d;
          color: #fff;
          display: flex;
          align-items: center;
          justify-content: center;
          min-height: 100vh;
      }
      .card {
          background: rgba(15, 15, 30, 0.9);
          border: 2px solid #1e90ff;
          border-radius: 20px;
          padding: 2rem;
          width: 100%;
          max-width: 420px;
          box-shadow: 0 0 25px rgba(30,144,255,0.6), 0 0 25px rgba(255,0,70,0.4);
          text-align: center;
      }
      .card img {
          width: 120px;
          margin-bottom: 1rem;
          filter: drop-shadow(0 0 12px rgba(30,144,255,0.8));
      }
      h2 {
          font-size: 1.6rem;
          margin-bottom: 1.5rem;
          background: linear-gradient(90deg, #1e90ff, #ff0046);
          -webkit-background-clip: text;
          -webkit-text-fill-color: transparent;
      }
      label {
          display: block;
          text-align: left;
          margin: 0.5rem 0 0.2rem;
          font-weight: bold;
          font-size: 0.9rem;
          color: #66b2ff;
      }
      input {
          width: 100%;
          padding: 0.8rem;
          border-radius: 10px;
          border: none;
          margin-bottom: 1rem;
          background: rgba(255,255,255,0.08);
          color: #fff;
          font-size: 1rem;
          outline: none;
          box-shadow: inset 0 0 8px rgba(30,144,255,0.5);
      }
      input::placeholder {
          color: #aaa;
      }
      button {
          width: 100%;
          padding: 0.9rem;
          border: none;
          border-radius: 12px;
          background: linear-gradient(90deg, #1e90ff, #ff0046);
          color: white;
          font-weight: bold;
          font-size: 1rem;
          cursor: pointer;
          transition: transform 0.2s, box-shadow 0.3s;
          box-shadow: 0 0 12px rgba(30,144,255,0.6), 0 0 12px rgba(255,0,70,0.4);
      }
      button:hover {
          transform: scale(1.05);
          box-shadow: 0 0 25px rgba(30,144,255,0.8), 0 0 25px rgba(255,0,70,0.6);
      }
      .message {
          margin-bottom: 1rem;
          font-size: 0.9rem;
      }
      /* Botón Más Apps */
      .apps-btn {
          display: inline-block;
          margin-top: 1rem;
          padding: 0.9rem;
          width: 100%;
          border-radius: 12px;
          text-decoration: none;
          font-weight: bold;
          font-size: 1rem;
          text-align: center;
          background: linear-gradient(90deg, #25D366, #128C7E);
          color: #fff;
          box-shadow: 0 0 15px rgba(37,211,102,0.6);
          transition: transform 0.2s, box-shadow 0.3s;
      }
      .apps-btn:hover {
          transform: scale(1.05);
          box-shadow: 0 0 25px rgba(37,211,102,0.9);
      }
  </style>
</head>
<body>
    <div class="card">
        <img src="/img/logo.png" alt="Logo">
        <h2>Agregar un Nuevo Código</h2>

        <?php if (isset($_SESSION['message'])): ?>
            <p class="message"><?= $_SESSION['message']; ?></p>
            <?php unset($_SESSION['message']); ?>
        <?php endif; ?>

        <form method="POST">
            <label for="codigo">Código de Activación</label>
            <input type="text" id="codigo" name="codigo" placeholder="4D7E65A265" maxlength="17" required>

            <label for="username">Nombre de Usuario</label>
            <input type="text" id="username" name="username" placeholder="Usuario" maxlength="17" required>

            <label for="password">Contraseña</label>
            <input type="text" id="password" name="password" placeholder="Clave" maxlength="17" required>

            <button type="submit">Agregar Código</button>
        </form>

        <!-- Botón WhatsApp -->
        <a href="https://wa.me/527474985302" target="_blank" class="apps-btn">📱 Más Apps</a>
    </div>
</body>
</html>
